# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 8
# Experiment: DAxDA, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR8_strategy.txt
# LLM Suggested Fallback: Not Provided

def sunshine_optimist_v3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate bloom score to track opponent's cooperation tendency
    bloom_score = sum(1 for move in opp_history if move == "C") / len(opp_history) if opp_history else 0.5
    
    # Initial trust-building phase (Rounds 1-3)
    if len(my_history) == 0:
        return "C"  # Start with cooperation to appear trustworthy
    if len(my_history) == 1:
        return "C"  # Continue cooperation to build trust
    if len(my_history) == 2:
        return "D"  # Strategic defection to break opponent's expectation
    
    # Mid-game phase (Rounds 4-6)
    if len(my_history) == 3:
        return "C"  # Confuse opponent by cooperating when they expect defection
    if len(my_history) == 4:
        return "D"  # Destabilize opponent's trust calculation
    if len(my_history) == 5:
        return "C"  # Create illusion of inconsistency
    
    # Late-game phase (Rounds 7-10)
    if len(my_history) == 6:
        return "D"  # Alternate to defection
    if len(my_history) == 7:
        return "C"  # Alternate to cooperation
    if len(my_history) == 8:
        return "D"  # Defect again to maximize payoff
    if len(my_history) == 9:
        return "D"  # Final defection to exploit opponent's likely forgiveness
    
    # Fallback to cooperation if unexpected round count
    return "C"